(defmeth vista-RewCat-proto :standard-coef-estimates ()
  (let* ((std-y (standard-deviation (send (send self :curr-model) :y)))
         (std-x (combine 0 (mapcar #'(lambda (var) (if (variancep var) (standard-deviation var)
                                                       0))
                                   (cdr (column-list (send (send self :curr-model) :x-matrix))))))
         (coefs (send (send self :curr-model) :coef-estimates))
         )
    (mapcar #'(lambda (c x) (* c (/ x std-y)))
            coefs std-x)))

(defmeth regression-model-proto :adjusted-r-squared ()
  (- (send self :r-squared) (/ (* (length (send self :basis)) (- 1 (send self :r-squared)))
                               (- (send self :num-cases) (1+ (length (send self :basis)))))))

(defmeth vista-RewCat-proto :parametters-plot ()
  (let* ((obj self)
         (cur-model (send obj :curr-model))
         (coefs (send cur-model :coef-estimates))
         (coef-standard-errors (send cur-model :coef-standard-errors))
         (t_s (/ coefs coef-standard-errors))
         (std-coefs (send self :standard-coef-estimates))
        #| (coefs (combine (first std-coefs)
                         (select (cdr std-coefs) (send cur-model :basis))))|#
         (pos (position cur-model (send self :models-adjusted-list) :test 'equal))
         (x (combine 1 
                     (select (+ 2  (combine (mapcar #'(lambda (i j) (repeat i j))
                                          (iseq (length (select (send obj :blocks) pos)))
                                          (select (send obj :blocks) pos))))
                             (send cur-model :basis))))
         (plot  (scatterplot (list x std-coefs coefs coef-standard-errors t_s)
                             :variable-labels (list "Index" "Coef. standards" "Coeficients" "Standard Error of Coef." "t of Coef.")
                             :labels (combine "Const" 
                                              (select (send cur-model :predictor-names) 
                                                      (send cur-model :basis)))))
         )
    (send plot :range '0 0 (+ 1 (max x)))
    (send plot :vista-look-and-feel)
    (defmeth plot :new-x ()
      )
    (defmeth plot :print-var-labels ()
      (let* (
             (cur-model (send obj :curr-model))
             (posi (position cur-model (send obj :models-adjusted-list) :test 'equal))
             (model (select (send obj :model) posi))
             (num-indicators (length (send obj :label-current-indicators)))
             (num-var (iseq (+ 1 num-indicators (length model))))
             (min-range (min (send self :range (second (send self :content-variables)))))
             (max-range (max (send self :range (second (send self :content-variables)))))
             ;(min-range 0)
             (positions (mapcar #'(lambda (var) (send self :real-to-canvas var min-range))
                                (+ 1 num-var)))
             (terms (combine "Const" model))
             (terms (if (> num-indicators 0) 
                        (combine terms (send obj :label-current-indicators))
                        terms))
             (max-length (max (mapcar #'(lambda (len) (send self :text-width len))
                                      terms)))
             )
        (send plot :draw-color 'brown)
        
        ; (mapcar #'(lambda (pos term)  
                      ;            (send self :draw-text-up term (first pos) 
                                         ;    (-  (second pos) (- max-length 2)) 0 1)) positions terms)
        (mapcar #'(lambda (posx term)  
                    (send self :draw-text-up term (first posx) 
                          (second posx) 0 1)) positions terms)
        (send plot :draw-color 'black)
        max-length
        ))
    (defmeth plot :redraw-content ()
      (call-next-method)
      (send plot :print-var-labels))

    (defmeth plot :update-plotcell (&rest args)
	(cond (
		(equal (second args) "duplicate")
			(send self :start-buffering)
			(setf sel (send self :selection))
			(send self :new-plot)
			(send self :selection sel)
			(send self :redraw)
			(send self :buffer-to-screen))
		
      		(
		(or (equal (first args) "terms") (equal (first args) "dev-plot"))
            		(send self :new-plot)
		)
  	))


    (defmeth plot :new-plot ()
      (send plot :start-buffering)
      (let* ((present-model (send obj :curr-model))
             (present-std-coefs (send obj :standard-coef-estimates))
             (present-coefs (send present-model :coef-estimates))
             (coef-standard-errors (send present-model :coef-standard-errors))
             (t_s (/ present-coefs coef-standard-errors))
             (pos (position present-model (send obj :models-adjusted-list) :test 'equal))
             (x (combine 1 (select (+ 2  (combine (mapcar #'(lambda (i j) (repeat i j))
                                                         (iseq (length (select (send obj :blocks) pos)))
                                                         (select (send obj :blocks) pos))))
                                   (send present-model :basis)))))
        (send self :clear-points)
        (send self :add-points (list x present-std-coefs present-coefs coef-standard-errors t_s))
        (send self :point-label (iseq (length x))
              (combine "Const" (select (send present-model :predictor-names) (send present-model :basis))))
        (send self :adjust-to-data)
        (send self :range '0 0 (+ 1 (max x)))
        (send self :print-var-labels)
        )
      (send plot :buffer-to-screen))
    
    plot
    ))


(defmeth vista-RewCat-proto  :label-current-indicators ()

  (let* ((terms (expand-hierarchy 
                         (list (iseq (length (send self :vars))))))
         (terms-selected (select (send self :terms) 
                                         (position (send self :curr-model) 
                                                   (send self :models-adjusted-list))))
         (indicators-term (select terms-selected 
                          (which (mapcar #'(lambda (ter) (>= ter (length terms)))
                                         terms-selected)))))
  (mapcar #'(lambda (term) 
             (first (select (send self :indicators-list)
                      (- term (length (send self :list-terms))))))
          indicators-term)))


(defmeth vista-RewCat-proto :current-set-model ()
  (let* ((curr-model (send self :curr-model))
         (pos (position curr-model (send self :models-adjusted-list) :test 'equal))
         (set-model (select (send self :terms) pos))
         (terms (send self :list-terms))
         (terms-vars (mapcar #'(lambda (st-mod) (select terms st-mod))
             set-model)))
    (mapcar #'(lambda (f) (apply 'strcat (car f)
                                 (mapcar #'(lambda (g) 
                                             (strcat "|" g )) 
                                         (cdr f))))
            terms-vars)
    ))

  (defmeth vista-RewCat-proto :cooks-distances ()
    "Message args: ()
Computes Cook's distances. Modified by PV for accomodating values of leverages equal to 1. "
    (let* ((obj (send self :curr-model))
           (lev (send obj :leverages))
           (res (/ (^ (send obj :studentized-residuals) 2)
                  (send obj :num-coefs)))
           (included (send obj :included)))
      (mapcar #'(lambda (i l r) (if (and i (/= l 1))  (* r (/ l (- 1 l) ))   (* r l)))
        included lev res)))
